System.register("chunks:///internal.js", ['./rollupPluginModLoBabelHelpers-dbd17f8d.js', 'cc'], function () {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, _createClass, _createForOfIteratorHelperLoose, cclegacy, gfx, ccenum, _decorator, Camera, CCBoolean, CCInteger, CCFloat, Material, Texture2D, rendering, Component, geometry, renderer, assert, Layers, PipelineEventType, Vec2, Vec4, sys, pipeline, Vec3, warn, clamp;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module._;
      _inheritsLoose = module.a;
      _initializerDefineProperty = module.b;
      _assertThisInitialized = module.c;
      _createClass = module.d;
      _createForOfIteratorHelperLoose = module.e;
    }, function (module) {
      cclegacy = module.cclegacy;
      gfx = module.gfx;
      ccenum = module.ccenum;
      _decorator = module._decorator;
      Camera = module.Camera;
      CCBoolean = module.CCBoolean;
      CCInteger = module.CCInteger;
      CCFloat = module.CCFloat;
      Material = module.Material;
      Texture2D = module.Texture2D;
      rendering = module.rendering;
      Component = module.Component;
      geometry = module.geometry;
      renderer = module.renderer;
      assert = module.assert;
      Layers = module.Layers;
      PipelineEventType = module.PipelineEventType;
      Vec2 = module.Vec2;
      Vec4 = module.Vec4;
      sys = module.sys;
      pipeline = module.pipeline;
      Vec3 = module.Vec3;
      warn = module.warn;
      clamp = module.clamp;
    }],
    execute: function () {
      cclegacy._RF.push({}, "cbf30kCUX9A3K+QpVC6wnzx", "builtin-pipeline-types", undefined);
      var SampleCount = gfx.SampleCount;
      function makeMSAA() {
        return {
          enabled: false,
          sampleCount: SampleCount.X4
        };
      }
      function fillRequiredMSAA(value) {
        if (value.enabled === undefined) {
          value.enabled = false;
        }
        if (value.sampleCount === undefined) {
          value.sampleCount = SampleCount.X4;
        }
      }
      var BloomType = /*#__PURE__*/function (BloomType) {
        BloomType[BloomType["KawaseDualFilter"] = 0] = "KawaseDualFilter";
        BloomType[BloomType["MipmapFilter"] = 1] = "MipmapFilter";
        return BloomType;
      }({});
      ccenum(BloomType);
      function makeBloom() {
        return {
          enabled: false,
          type: BloomType.KawaseDualFilter,
          material: null,
          kawaseFilterMaterial: null,
          mipmapFilterMaterial: null,
          enableAlphaMask: false,
          iterations: 3,
          threshold: 0.8,
          intensity: 1
        };
      }
      function fillRequiredBloom(value) {
        if (value.enabled === undefined) {
          value.enabled = false;
        }
        if (value.type === undefined) {
          value.type = BloomType.KawaseDualFilter;
        }
        if (value.material === undefined) {
          value.material = null;
        }
        if (value.kawaseFilterMaterial === undefined) {
          value.kawaseFilterMaterial = value.material || null;
        }
        if (value.mipmapFilterMaterial === undefined) {
          value.mipmapFilterMaterial = null;
        }
        if (value.enableAlphaMask === undefined) {
          value.enableAlphaMask = false;
        }
        if (value.iterations === undefined) {
          value.iterations = 3;
        }
        if (value.threshold === undefined) {
          value.threshold = 0.8;
        }
        if (value.intensity === undefined) {
          value.intensity = 1;
        }
      }
      function makeColorGrading() {
        return {
          enabled: false,
          material: null,
          contribute: 1,
          colorGradingMap: null
        };
      }
      function fillRequiredColorGrading(value) {
        if (value.enabled === undefined) {
          value.enabled = false;
        }
        if (value.material === undefined) {
          value.material = null;
        }
        if (value.contribute === undefined) {
          value.contribute = 1;
        }
        if (value.colorGradingMap === undefined) {
          value.colorGradingMap = null;
        }
      }
      function makeFSR() {
        return {
          enabled: false,
          material: null,
          sharpness: 0.8
        };
      }
      function fillRequiredFSR(value) {
        if (value.enabled === undefined) {
          value.enabled = false;
        }
        if (value.material === undefined) {
          value.material = null;
        }
        if (value.sharpness === undefined) {
          value.sharpness = 0.8;
        }
      }
      function makeFXAA() {
        return {
          enabled: false,
          material: null
        };
      }
      function fillRequiredFXAA(value) {
        if (value.enabled === undefined) {
          value.enabled = false;
        }
        if (value.material === undefined) {
          value.material = null;
        }
      }
      function makeToneMapping() {
        return {
          material: null
        };
      }
      function fillRequiredToneMapping(value) {
        if (value.material === undefined) {
          value.material = null;
        }
      }
      function makePipelineSettings() {
        return {
          msaa: makeMSAA(),
          enableShadingScale: false,
          shadingScale: 0.5,
          bloom: makeBloom(),
          toneMapping: makeToneMapping(),
          colorGrading: makeColorGrading(),
          fsr: makeFSR(),
          fxaa: makeFXAA()
        };
      }
      function fillRequiredPipelineSettings(value) {
        if (!value.msaa) {
          value.msaa = makeMSAA();
        } else {
          fillRequiredMSAA(value.msaa);
        }
        if (value.enableShadingScale === undefined) {
          value.enableShadingScale = false;
        }
        if (value.shadingScale === undefined) {
          value.shadingScale = 0.5;
        }
        if (!value.bloom) {
          value.bloom = makeBloom();
        } else {
          fillRequiredBloom(value.bloom);
        }
        if (!value.toneMapping) {
          value.toneMapping = makeToneMapping();
        } else {
          fillRequiredToneMapping(value.toneMapping);
        }
        if (!value.colorGrading) {
          value.colorGrading = makeColorGrading();
        } else {
          fillRequiredColorGrading(value.colorGrading);
        }
        if (!value.fsr) {
          value.fsr = makeFSR();
        } else {
          fillRequiredFSR(value.fsr);
        }
        if (!value.fxaa) {
          value.fxaa = makeFXAA();
        } else {
          fillRequiredFXAA(value.fxaa);
        }
      }
      cclegacy._RF.pop();
      var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _dec11, _dec12, _dec13, _dec14, _dec15, _dec16, _dec17, _dec18, _dec19, _dec20, _dec21, _dec22, _dec23, _dec24, _dec25, _dec26, _dec27, _dec28, _dec29, _class, _class2, _descriptor, _descriptor2;
      cclegacy._RF.push({}, "de1c2EHcMhAIYRZY5nyTQHG", "builtin-pipeline-settings", undefined);
      var ccclass = _decorator.ccclass,
        disallowMultiple = _decorator.disallowMultiple,
        executeInEditMode = _decorator.executeInEditMode,
        menu = _decorator.menu,
        property = _decorator.property,
        requireComponent = _decorator.requireComponent,
        type = _decorator.type;
      var BuiltinPipelineSettings = (_dec = ccclass('BuiltinPipelineSettings'), _dec2 = menu('Rendering/BuiltinPipelineSettings'), _dec3 = requireComponent(Camera), _dec4 = property(CCBoolean), _dec5 = property({
        displayName: 'Editor Preview (Experimental)',
        type: CCBoolean
      }), _dec6 = property({
        group: {
          id: 'MSAA',
          name: 'Multisample Anti-Aliasing'
        },
        type: CCBoolean
      }), _dec7 = property({
        group: {
          id: 'MSAA',
          name: 'Multisample Anti-Aliasing',
          style: 'section'
        },
        type: CCInteger,
        range: [2, 4, 2]
      }), _dec8 = property({
        group: {
          id: 'ShadingScale',
          name: 'ShadingScale',
          style: 'section'
        },
        type: CCBoolean
      }), _dec9 = property({
        tooltip: 'i18n:postprocess.shadingScale',
        group: {
          id: 'ShadingScale',
          name: 'ShadingScale'
        },
        type: CCFloat,
        range: [0.01, 4, 0.01],
        slide: true
      }), _dec10 = property({
        group: {
          id: 'Bloom',
          name: 'Bloom (PostProcessing)',
          style: 'section'
        },
        type: CCBoolean
      }), _dec11 = type(BloomType), _dec12 = property({
        group: {
          id: 'Bloom',
          name: 'Bloom (PostProcessing)',
          style: 'section'
        }
      }), _dec13 = property({
        group: {
          id: 'Bloom',
          name: 'Bloom (PostProcessing)',
          style: 'section'
        },
        type: Material
      }), _dec14 = property({
        group: {
          id: 'Bloom',
          name: 'Bloom (PostProcessing)',
          style: 'section'
        },
        type: Material
      }), _dec15 = property({
        tooltip: 'i18n:bloom.enableAlphaMask',
        group: {
          id: 'Bloom',
          name: 'Bloom (PostProcessing)',
          style: 'section'
        },
        type: CCBoolean
      }), _dec16 = property({
        tooltip: 'i18n:bloom.iterations',
        group: {
          id: 'Bloom',
          name: 'Bloom (PostProcessing)',
          style: 'section'
        },
        type: CCInteger,
        range: [1, 6, 1],
        slide: true
      }), _dec17 = property({
        tooltip: 'i18n:bloom.threshold',
        group: {
          id: 'Bloom',
          name: 'Bloom (PostProcessing)',
          style: 'section'
        },
        type: CCFloat,
        min: 0
      }), _dec18 = type(CCFloat), _dec19 = property({
        group: {
          id: 'Bloom',
          name: 'Bloom (PostProcessing)',
          style: 'section'
        }
      }), _dec20 = property({
        group: {
          id: 'Color Grading',
          name: 'ColorGrading (LDR) (PostProcessing)',
          style: 'section'
        },
        type: CCBoolean
      }), _dec21 = property({
        group: {
          id: 'Color Grading',
          name: 'ColorGrading (LDR) (PostProcessing)',
          style: 'section'
        },
        type: Material
      }), _dec22 = property({
        tooltip: 'i18n:color_grading.contribute',
        group: {
          id: 'Color Grading',
          name: 'ColorGrading (LDR) (PostProcessing)',
          style: 'section'
        },
        type: CCFloat,
        range: [0, 1, 0.01],
        slide: true
      }), _dec23 = property({
        tooltip: 'i18n:color_grading.originalMap',
        group: {
          id: 'Color Grading',
          name: 'ColorGrading (LDR) (PostProcessing)',
          style: 'section'
        },
        type: Texture2D
      }), _dec24 = property({
        group: {
          id: 'FXAA',
          name: 'Fast Approximate Anti-Aliasing (PostProcessing)',
          style: 'section'
        },
        type: CCBoolean
      }), _dec25 = property({
        group: {
          id: 'FXAA',
          name: 'Fast Approximate Anti-Aliasing (PostProcessing)',
          style: 'section'
        },
        type: Material
      }), _dec26 = property({
        group: {
          id: 'FSR',
          name: 'FidelityFX Super Resolution',
          style: 'section'
        },
        type: CCBoolean
      }), _dec27 = property({
        group: {
          id: 'FSR',
          name: 'FidelityFX Super Resolution',
          style: 'section'
        },
        type: Material
      }), _dec28 = property({
        group: {
          id: 'FSR',
          name: 'FidelityFX Super Resolution',
          style: 'section'
        },
        type: CCFloat,
        range: [0, 1, 0.01],
        slide: true
      }), _dec29 = property({
        group: {
          id: 'ToneMapping',
          name: 'ToneMapping',
          style: 'section'
        },
        type: Material
      }), _dec(_class = _dec2(_class = _dec3(_class = disallowMultiple(_class = executeInEditMode(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BuiltinPipelineSettings, _Component);
        function BuiltinPipelineSettings() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "_settings", _descriptor, _assertThisInitialized(_this));
          // Editor Preview
          _initializerDefineProperty(_this, "_editorPreview", _descriptor2, _assertThisInitialized(_this));
          return _this;
        }
        var _proto = BuiltinPipelineSettings.prototype;
        _proto.getPipelineSettings = function getPipelineSettings() {
          return this._settings;
        }

        // Enable/Disable
        ;

        _proto.onEnable = function onEnable() {
          fillRequiredPipelineSettings(this._settings);
          var cameraComponent = this.getComponent(Camera);
          var camera = cameraComponent.camera;
          camera.pipelineSettings = this._settings;
        };
        _proto.onDisable = function onDisable() {
          var cameraComponent = this.getComponent(Camera);
          var camera = cameraComponent.camera;
          if (camera) {
            camera.pipelineSettings = null;
          }
        };
        _proto._tryEnableEditorPreview = function _tryEnableEditorPreview() {
          if (rendering === undefined) {
            return;
          }
          if (this._editorPreview) {
            rendering.setEditorPipelineSettings(this._settings);
          } else {
            this._disableEditorPreview();
          }
        };
        _proto._disableEditorPreview = function _disableEditorPreview() {
          if (rendering === undefined) {
            return;
          }
          var current = rendering.getEditorPipelineSettings();
          if (current === this._settings) {
            rendering.setEditorPipelineSettings(null);
          }
        }

        // MSAA
        ;

        _createClass(BuiltinPipelineSettings, [{
          key: "editorPreview",
          get: function get() {
            return this._editorPreview;
          },
          set: function set(v) {
            this._editorPreview = v;
          }
        }, {
          key: "MsaaEnable",
          get: function get() {
            return this._settings.msaa.enabled;
          },
          set: function set(value) {
            this._settings.msaa.enabled = value;
          }
        }, {
          key: "msaaSampleCount",
          get: function get() {
            return this._settings.msaa.sampleCount;
          }

          // Shading Scale
          ,

          set: function set(value) {
            value = Math.pow(2, Math.ceil(Math.log2(Math.max(value, 2))));
            value = Math.min(value, 4);
            this._settings.msaa.sampleCount = value;
          }
        }, {
          key: "shadingScaleEnable",
          get: function get() {
            return this._settings.enableShadingScale;
          },
          set: function set(value) {
            this._settings.enableShadingScale = value;
          }
        }, {
          key: "shadingScale",
          get: function get() {
            return this._settings.shadingScale;
          }

          // Bloom
          ,

          set: function set(value) {
            this._settings.shadingScale = value;
          }
        }, {
          key: "bloomEnable",
          get: function get() {
            return this._settings.bloom.enabled;
          },
          set: function set(value) {
            this._settings.bloom.enabled = value;
          }
        }, {
          key: "bloomType",
          get: function get() {
            return this._settings.bloom.type;
          },
          set: function set(value) {
            this._settings.bloom.type = value;
          }
        }, {
          key: "kawaseBloomMaterial",
          get: function get() {
            return this._settings.bloom.kawaseFilterMaterial;
          },
          set: function set(value) {
            if (this._settings.bloom.kawaseFilterMaterial === value) {
              return;
            }
            this._settings.bloom.kawaseFilterMaterial = value;
          }
        }, {
          key: "mipmapBloomMaterial",
          get: function get() {
            return this._settings.bloom.mipmapFilterMaterial;
          },
          set: function set(value) {
            if (this._settings.bloom.mipmapFilterMaterial === value) {
              return;
            }
            this._settings.bloom.mipmapFilterMaterial = value;
          }
        }, {
          key: "bloomEnableAlphaMask",
          get: function get() {
            return this._settings.bloom.enableAlphaMask;
          },
          set: function set(value) {
            this._settings.bloom.enableAlphaMask = value;
          }
        }, {
          key: "bloomIterations",
          get: function get() {
            return this._settings.bloom.iterations;
          },
          set: function set(value) {
            this._settings.bloom.iterations = value;
          }
        }, {
          key: "bloomThreshold",
          get: function get() {
            return this._settings.bloom.threshold;
          },
          set: function set(value) {
            this._settings.bloom.threshold = value;
          }
        }, {
          key: "bloomIntensity",
          get: function get() {
            return this._settings.bloom.intensity;
          }

          // Color Grading (LDR)
          ,

          set: function set(value) {
            this._settings.bloom.intensity = value;
          }
        }, {
          key: "colorGradingEnable",
          get: function get() {
            return this._settings.colorGrading.enabled;
          },
          set: function set(value) {
            this._settings.colorGrading.enabled = value;
          }
        }, {
          key: "colorGradingMaterial",
          get: function get() {
            return this._settings.colorGrading.material;
          },
          set: function set(value) {
            if (this._settings.colorGrading.material === value) {
              return;
            }
            this._settings.colorGrading.material = value;
          }
        }, {
          key: "colorGradingContribute",
          get: function get() {
            return this._settings.colorGrading.contribute;
          },
          set: function set(value) {
            this._settings.colorGrading.contribute = value;
          }
        }, {
          key: "colorGradingMap",
          get: function get() {
            return this._settings.colorGrading.colorGradingMap;
          }

          // FXAA
          ,

          set: function set(val) {
            this._settings.colorGrading.colorGradingMap = val;
          }
        }, {
          key: "fxaaEnable",
          get: function get() {
            return this._settings.fxaa.enabled;
          },
          set: function set(value) {
            this._settings.fxaa.enabled = value;
          }
        }, {
          key: "fxaaMaterial",
          get: function get() {
            return this._settings.fxaa.material;
          }

          // FSR
          ,

          set: function set(value) {
            if (this._settings.fxaa.material === value) {
              return;
            }
            this._settings.fxaa.material = value;
          }
        }, {
          key: "fsrEnable",
          get: function get() {
            return this._settings.fsr.enabled;
          },
          set: function set(value) {
            this._settings.fsr.enabled = value;
          }
        }, {
          key: "fsrMaterial",
          get: function get() {
            return this._settings.fsr.material;
          },
          set: function set(value) {
            if (this._settings.fsr.material === value) {
              return;
            }
            this._settings.fsr.material = value;
          }
        }, {
          key: "fsrSharpness",
          get: function get() {
            return this._settings.fsr.sharpness;
          },
          set: function set(value) {
            this._settings.fsr.sharpness = value;
          }
        }, {
          key: "toneMappingMaterial",
          get: function get() {
            return this._settings.toneMapping.material;
          },
          set: function set(value) {
            if (this._settings.toneMapping.material === value) {
              return;
            }
            this._settings.toneMapping.material = value;
          }
        }]);
        return BuiltinPipelineSettings;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "_settings", [property], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return makePipelineSettings();
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "_editorPreview", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return false;
        }
      }), _applyDecoratedDescriptor(_class2.prototype, "editorPreview", [_dec5], Object.getOwnPropertyDescriptor(_class2.prototype, "editorPreview"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "MsaaEnable", [_dec6], Object.getOwnPropertyDescriptor(_class2.prototype, "MsaaEnable"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "msaaSampleCount", [_dec7], Object.getOwnPropertyDescriptor(_class2.prototype, "msaaSampleCount"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "shadingScaleEnable", [_dec8], Object.getOwnPropertyDescriptor(_class2.prototype, "shadingScaleEnable"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "shadingScale", [_dec9], Object.getOwnPropertyDescriptor(_class2.prototype, "shadingScale"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "bloomEnable", [_dec10], Object.getOwnPropertyDescriptor(_class2.prototype, "bloomEnable"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "bloomType", [_dec11, _dec12], Object.getOwnPropertyDescriptor(_class2.prototype, "bloomType"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "kawaseBloomMaterial", [_dec13], Object.getOwnPropertyDescriptor(_class2.prototype, "kawaseBloomMaterial"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "mipmapBloomMaterial", [_dec14], Object.getOwnPropertyDescriptor(_class2.prototype, "mipmapBloomMaterial"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "bloomEnableAlphaMask", [_dec15], Object.getOwnPropertyDescriptor(_class2.prototype, "bloomEnableAlphaMask"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "bloomIterations", [_dec16], Object.getOwnPropertyDescriptor(_class2.prototype, "bloomIterations"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "bloomThreshold", [_dec17], Object.getOwnPropertyDescriptor(_class2.prototype, "bloomThreshold"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "bloomIntensity", [_dec18, _dec19], Object.getOwnPropertyDescriptor(_class2.prototype, "bloomIntensity"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "colorGradingEnable", [_dec20], Object.getOwnPropertyDescriptor(_class2.prototype, "colorGradingEnable"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "colorGradingMaterial", [_dec21], Object.getOwnPropertyDescriptor(_class2.prototype, "colorGradingMaterial"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "colorGradingContribute", [_dec22], Object.getOwnPropertyDescriptor(_class2.prototype, "colorGradingContribute"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "colorGradingMap", [_dec23], Object.getOwnPropertyDescriptor(_class2.prototype, "colorGradingMap"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "fxaaEnable", [_dec24], Object.getOwnPropertyDescriptor(_class2.prototype, "fxaaEnable"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "fxaaMaterial", [_dec25], Object.getOwnPropertyDescriptor(_class2.prototype, "fxaaMaterial"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "fsrEnable", [_dec26], Object.getOwnPropertyDescriptor(_class2.prototype, "fsrEnable"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "fsrMaterial", [_dec27], Object.getOwnPropertyDescriptor(_class2.prototype, "fsrMaterial"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "fsrSharpness", [_dec28], Object.getOwnPropertyDescriptor(_class2.prototype, "fsrSharpness"), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, "toneMappingMaterial", [_dec29], Object.getOwnPropertyDescriptor(_class2.prototype, "toneMappingMaterial"), _class2.prototype)), _class2)) || _class) || _class) || _class) || _class) || _class);
      cclegacy._RF.pop();
      cclegacy._RF.push({}, "ff9b0GZzgRM/obMbHGfCNbk", "builtin-pipeline", undefined);
      var AABB = geometry.AABB,
        Sphere = geometry.Sphere,
        intersect = geometry.intersect;
      var ClearFlagBit = gfx.ClearFlagBit,
        Color = gfx.Color,
        Format = gfx.Format,
        FormatFeatureBit = gfx.FormatFeatureBit,
        LoadOp = gfx.LoadOp,
        StoreOp = gfx.StoreOp,
        TextureType = gfx.TextureType,
        Viewport = gfx.Viewport;
      var scene = renderer.scene;
      var CameraUsage = scene.CameraUsage,
        CSMLevel = scene.CSMLevel,
        LightType = scene.LightType;
      function forwardNeedClearColor(camera) {
        return !!(camera.clearFlag & (ClearFlagBit.COLOR | ClearFlagBit.STENCIL << 1));
      }
      function getCsmMainLightViewport(light, w, h, level, vp, screenSpaceSignY) {
        if (light.shadowFixedArea || light.csmLevel === CSMLevel.LEVEL_1) {
          vp.left = 0;
          vp.top = 0;
          vp.width = Math.trunc(w);
          vp.height = Math.trunc(h);
        } else {
          vp.left = Math.trunc(level % 2 * 0.5 * w);
          if (screenSpaceSignY > 0) {
            vp.top = Math.trunc((1 - Math.floor(level / 2)) * 0.5 * h);
          } else {
            vp.top = Math.trunc(Math.floor(level / 2) * 0.5 * h);
          }
          vp.width = Math.trunc(0.5 * w);
          vp.height = Math.trunc(0.5 * h);
        }
        vp.left = Math.max(0, vp.left);
        vp.top = Math.max(0, vp.top);
        vp.width = Math.max(1, vp.width);
        vp.height = Math.max(1, vp.height);
      }
      var PipelineConfigs = function PipelineConfigs() {
        this.isWeb = false;
        this.isWebGL1 = false;
        this.isWebGPU = false;
        this.isMobile = false;
        this.isHDR = false;
        this.useFloatOutput = false;
        this.toneMappingType = 0;
        // 0: ACES, 1: None
        this.shadowEnabled = false;
        this.shadowMapFormat = Format.R32F;
        this.shadowMapSize = new Vec2(1, 1);
        this.usePlanarShadow = false;
        this.screenSpaceSignY = 1;
        this.supportDepthSample = false;
        this.mobileMaxSpotLightShadowMaps = 1;
        this.platform = new Vec4(0, 0, 0, 0);
      };
      function setupPipelineConfigs(ppl, configs) {
        var sampleFeature = FormatFeatureBit.SAMPLED_TEXTURE | FormatFeatureBit.LINEAR_FILTER;
        var device = ppl.device;
        // Platform
        configs.isWeb = !sys.isNative;
        configs.isWebGL1 = device.gfxAPI === gfx.API.WEBGL;
        configs.isWebGPU = device.gfxAPI === gfx.API.WEBGPU;
        configs.isMobile = sys.isMobile;

        // Rendering
        configs.isHDR = ppl.pipelineSceneData.isHDR; // Has tone mapping
        configs.useFloatOutput = ppl.getMacroBool('CC_USE_FLOAT_OUTPUT');
        configs.toneMappingType = ppl.pipelineSceneData.postSettings.toneMappingType;
        // Shadow
        var shadowInfo = ppl.pipelineSceneData.shadows;
        configs.shadowEnabled = shadowInfo.enabled;
        configs.shadowMapFormat = pipeline.supportsR32FloatTexture(ppl.device) ? Format.R32F : Format.RGBA8;
        configs.shadowMapSize.set(shadowInfo.size);
        configs.usePlanarShadow = shadowInfo.enabled && shadowInfo.type === renderer.scene.ShadowType.Planar;
        // Device
        configs.screenSpaceSignY = ppl.device.capabilities.screenSpaceSignY;
        configs.supportDepthSample = (ppl.device.getFormatFeatures(Format.DEPTH_STENCIL) & sampleFeature) === sampleFeature;
        // Constants
        var screenSpaceSignY = device.capabilities.screenSpaceSignY;
        configs.platform.x = configs.isMobile ? 1.0 : 0.0;
        configs.platform.w = screenSpaceSignY * 0.5 + 0.5 << 1 | device.capabilities.clipSpaceSignY * 0.5 + 0.5;
      }
      var defaultSettings = makePipelineSettings();
      var CameraConfigs = function CameraConfigs() {
        this.settings = defaultSettings;
        // Window
        this.isMainGameWindow = false;
        this.renderWindowId = 0;
        // Camera
        this.colorName = '';
        this.depthStencilName = '';
        // Pipeline
        this.enableFullPipeline = false;
        this.enableProfiler = false;
        this.remainingPasses = 0;
        // Shading Scale
        this.enableShadingScale = false;
        this.shadingScale = 1.0;
        this.nativeWidth = 1;
        this.nativeHeight = 1;
        this.width = 1;
        // Scaled width
        this.height = 1;
        // Scaled height
        // Radiance
        this.enableHDR = false;
        this.radianceFormat = gfx.Format.RGBA8;
        // Tone Mapping
        this.copyAndTonemapMaterial = null;
        // Depth
        /** @en mutable */
        this.enableStoreSceneDepth = false;
      };
      var sClearColorTransparentBlack = new Color(0, 0, 0, 0);
      function sortPipelinePassBuildersByConfigOrder(passBuilders) {
        passBuilders.sort(function (a, b) {
          return a.getConfigOrder() - b.getConfigOrder();
        });
      }
      function sortPipelinePassBuildersByRenderOrder(passBuilders) {
        passBuilders.sort(function (a, b) {
          return a.getRenderOrder() - b.getRenderOrder();
        });
      }
      function addCopyToScreenPass(ppl, pplConfigs, cameraConfigs, input) {
        assert(!!cameraConfigs.copyAndTonemapMaterial);
        var pass = ppl.addRenderPass(cameraConfigs.nativeWidth, cameraConfigs.nativeHeight, 'cc-tone-mapping');
        pass.addRenderTarget(cameraConfigs.colorName, LoadOp.CLEAR, StoreOp.STORE, sClearColorTransparentBlack);
        pass.addTexture(input, 'inputTexture');
        pass.addQueue(rendering.QueueHint.OPAQUE).addFullscreenQuad(cameraConfigs.copyAndTonemapMaterial, 1);
        return pass;
      }
      function getPingPongRenderTarget(prevName, prefix, id) {
        if (prevName.startsWith(prefix)) {
          return "" + prefix + (1 - Number(prevName.charAt(prefix.length))) + "_" + id;
        } else {
          return prefix + "0_" + id;
        }
      }
      var ForwardLighting = /*#__PURE__*/function () {
        function ForwardLighting() {
          // Active lights
          this.lights = [];
          // Active spot lights with shadows (Mutually exclusive with `lights`)
          this.shadowEnabledSpotLights = [];
          // Internal cached resources
          this._sphere = Sphere.create(0, 0, 0, 1);
          this._boundingBox = new AABB();
          this._rangedDirLightBoundingBox = new AABB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        }
        var _proto = ForwardLighting.prototype;
        // ----------------------------------------------------------------
        // Interface
        // ----------------------------------------------------------------
        _proto.cullLights = function cullLights(scene, frustum, cameraPos) {
          // TODO(zhouzhenglong): Make light culling native
          this.lights.length = 0;
          this.shadowEnabledSpotLights.length = 0;
          // spot lights
          for (var _iterator = _createForOfIteratorHelperLoose(scene.spotLights), _step; !(_step = _iterator()).done;) {
            var light = _step.value;
            if (light.baked) {
              continue;
            }
            Sphere.set(this._sphere, light.position.x, light.position.y, light.position.z, light.range);
            if (intersect.sphereFrustum(this._sphere, frustum)) {
              if (light.shadowEnabled) {
                this.shadowEnabledSpotLights.push(light);
              } else {
                this.lights.push(light);
              }
            }
          }
          // sphere lights
          for (var _iterator2 = _createForOfIteratorHelperLoose(scene.sphereLights), _step2; !(_step2 = _iterator2()).done;) {
            var _light = _step2.value;
            if (_light.baked) {
              continue;
            }
            Sphere.set(this._sphere, _light.position.x, _light.position.y, _light.position.z, _light.range);
            if (intersect.sphereFrustum(this._sphere, frustum)) {
              this.lights.push(_light);
            }
          }
          // point lights
          for (var _iterator3 = _createForOfIteratorHelperLoose(scene.pointLights), _step3; !(_step3 = _iterator3()).done;) {
            var _light2 = _step3.value;
            if (_light2.baked) {
              continue;
            }
            Sphere.set(this._sphere, _light2.position.x, _light2.position.y, _light2.position.z, _light2.range);
            if (intersect.sphereFrustum(this._sphere, frustum)) {
              this.lights.push(_light2);
            }
          }
          // ranged dir lights
          for (var _iterator4 = _createForOfIteratorHelperLoose(scene.rangedDirLights), _step4; !(_step4 = _iterator4()).done;) {
            var _light3 = _step4.value;
            AABB.transform(this._boundingBox, this._rangedDirLightBoundingBox, _light3.node.getWorldMatrix());
            if (intersect.aabbFrustum(this._boundingBox, frustum)) {
              this.lights.push(_light3);
            }
          }
          if (cameraPos) {
            this.shadowEnabledSpotLights.sort(function (lhs, rhs) {
              return Vec3.squaredDistance(cameraPos, lhs.position) - Vec3.squaredDistance(cameraPos, rhs.position);
            });
          }
        };
        _proto._addLightQueues = function _addLightQueues(camera, pass) {
          for (var _iterator5 = _createForOfIteratorHelperLoose(this.lights), _step5; !(_step5 = _iterator5()).done;) {
            var light = _step5.value;
            var queue = pass.addQueue(rendering.QueueHint.BLEND, 'forward-add');
            switch (light.type) {
              case LightType.SPHERE:
                queue.name = 'sphere-light';
                break;
              case LightType.SPOT:
                queue.name = 'spot-light';
                break;
              case LightType.POINT:
                queue.name = 'point-light';
                break;
              case LightType.RANGED_DIRECTIONAL:
                queue.name = 'ranged-directional-light';
                break;
              default:
                queue.name = 'unknown-light';
            }
            queue.addScene(camera, rendering.SceneFlags.BLEND, light);
          }
        };
        _proto.addSpotlightShadowPasses = function addSpotlightShadowPasses(ppl, camera, maxNumShadowMaps) {
          var i = 0;
          for (var _iterator6 = _createForOfIteratorHelperLoose(this.shadowEnabledSpotLights), _step6; !(_step6 = _iterator6()).done;) {
            var light = _step6.value;
            var shadowMapSize = ppl.pipelineSceneData.shadows.size;
            var shadowPass = ppl.addRenderPass(shadowMapSize.x, shadowMapSize.y, 'default');
            shadowPass.name = "SpotLightShadowPass" + i;
            shadowPass.addRenderTarget("SpotShadowMap" + i, LoadOp.CLEAR, StoreOp.STORE, new Color(1, 1, 1, 1));
            shadowPass.addDepthStencil("SpotShadowDepth" + i, LoadOp.CLEAR, StoreOp.DISCARD);
            shadowPass.addQueue(rendering.QueueHint.NONE, 'shadow-caster').addScene(camera, rendering.SceneFlags.OPAQUE | rendering.SceneFlags.MASK | rendering.SceneFlags.SHADOW_CASTER).useLightFrustum(light);
            ++i;
            if (i >= maxNumShadowMaps) {
              break;
            }
          }
        };
        _proto.addLightQueues = function addLightQueues(pass, camera, maxNumShadowMaps) {
          this._addLightQueues(camera, pass);
          var i = 0;
          for (var _iterator7 = _createForOfIteratorHelperLoose(this.shadowEnabledSpotLights), _step7; !(_step7 = _iterator7()).done;) {
            var light = _step7.value;
            // Add spot-light pass
            // Save last RenderPass to the `pass` variable
            // TODO(zhouzhenglong): Fix per queue addTexture
            pass.addTexture("SpotShadowMap" + i, 'cc_spotShadowMap');
            var queue = pass.addQueue(rendering.QueueHint.BLEND, 'forward-add');
            queue.addScene(camera, rendering.SceneFlags.BLEND, light);
            ++i;
            if (i >= maxNumShadowMaps) {
              break;
            }
          }
        }

        // Notice: ForwardLighting cannot handle a lot of lights.
        // If there are too many lights, the performance will be very poor.
        // If many lights are needed, please implement a forward+ or deferred rendering pipeline.
        ;

        _proto.addLightPasses = function addLightPasses(colorName, depthStencilName, depthStencilStoreOp, id,
        // window id
        width, height, camera, viewport, ppl, pass) {
          this._addLightQueues(camera, pass);
          var count = 0;
          var shadowMapSize = ppl.pipelineSceneData.shadows.size;
          for (var _iterator8 = _createForOfIteratorHelperLoose(this.shadowEnabledSpotLights), _step8; !(_step8 = _iterator8()).done;) {
            var light = _step8.value;
            var shadowPass = ppl.addRenderPass(shadowMapSize.x, shadowMapSize.y, 'default');
            shadowPass.name = 'SpotlightShadowPass';
            // Reuse csm shadow map
            shadowPass.addRenderTarget("ShadowMap" + id, LoadOp.CLEAR, StoreOp.STORE, new Color(1, 1, 1, 1));
            shadowPass.addDepthStencil("ShadowDepth" + id, LoadOp.CLEAR, StoreOp.DISCARD);
            shadowPass.addQueue(rendering.QueueHint.NONE, 'shadow-caster').addScene(camera, rendering.SceneFlags.OPAQUE | rendering.SceneFlags.MASK | rendering.SceneFlags.SHADOW_CASTER).useLightFrustum(light);

            // Add spot-light pass
            // Save last RenderPass to the `pass` variable
            ++count;
            var storeOp = count === this.shadowEnabledSpotLights.length ? depthStencilStoreOp : StoreOp.STORE;
            pass = ppl.addRenderPass(width, height, 'default');
            pass.name = 'SpotlightWithShadowMap';
            pass.setViewport(viewport);
            pass.addRenderTarget(colorName, LoadOp.LOAD);
            pass.addDepthStencil(depthStencilName, LoadOp.LOAD, storeOp);
            pass.addTexture("ShadowMap" + id, 'cc_spotShadowMap');
            var queue = pass.addQueue(rendering.QueueHint.BLEND, 'forward-add');
            queue.addScene(camera, rendering.SceneFlags.BLEND, light);
          }
          return pass;
        };
        _proto.isMultipleLightPassesNeeded = function isMultipleLightPassesNeeded() {
          return this.shadowEnabledSpotLights.length > 0;
        };
        return ForwardLighting;
      }();
      var BuiltinForwardPassBuilder = /*#__PURE__*/function () {
        function BuiltinForwardPassBuilder() {
          this.forwardLighting = new ForwardLighting();
          this._viewport = new Viewport();
          this._clearColor = new Color(0, 0, 0, 1);
          this._reflectionProbeClearColor = new Vec3(0, 0, 0);
        }
        var _proto2 = BuiltinForwardPassBuilder.prototype;
        _proto2.getConfigOrder = function getConfigOrder() {
          return BuiltinForwardPassBuilder.ConfigOrder;
        };
        _proto2.getRenderOrder = function getRenderOrder() {
          return BuiltinForwardPassBuilder.RenderOrder;
        };
        _proto2.configCamera = function configCamera(camera, pipelineConfigs, cameraConfigs) {
          // Shadow
          cameraConfigs.enableMainLightShadowMap = pipelineConfigs.shadowEnabled && !pipelineConfigs.usePlanarShadow && !!camera.scene && !!camera.scene.mainLight && camera.scene.mainLight.shadowEnabled;
          cameraConfigs.enableMainLightPlanarShadowMap = pipelineConfigs.shadowEnabled && pipelineConfigs.usePlanarShadow && !!camera.scene && !!camera.scene.mainLight && camera.scene.mainLight.shadowEnabled;

          // Reflection Probe
          cameraConfigs.enablePlanarReflectionProbe = cameraConfigs.isMainGameWindow || camera.cameraUsage === CameraUsage.SCENE_VIEW || camera.cameraUsage === CameraUsage.GAME_VIEW;

          // MSAA
          cameraConfigs.enableMSAA = cameraConfigs.settings.msaa.enabled && !cameraConfigs.enableStoreSceneDepth // Cannot store MS depth, resolve depth is also not cross-platform
          && !pipelineConfigs.isWeb // TODO(zhouzhenglong): remove this constraint
          && !pipelineConfigs.isWebGL1;

          // Forward rendering (Depend on MSAA and TBR)
          cameraConfigs.enableSingleForwardPass = pipelineConfigs.isMobile || cameraConfigs.enableMSAA;
          ++cameraConfigs.remainingPasses;
        };
        _proto2.windowResize = function windowResize(ppl, pplConfigs, cameraConfigs, window, camera, nativeWidth, nativeHeight) {
          var ResourceFlags = rendering.ResourceFlags;
          var ResourceResidency = rendering.ResourceResidency;
          var id = window.renderWindowId;
          var settings = cameraConfigs.settings;
          var width = cameraConfigs.enableShadingScale ? Math.max(Math.floor(nativeWidth * cameraConfigs.shadingScale), 1) : nativeWidth;
          var height = cameraConfigs.enableShadingScale ? Math.max(Math.floor(nativeHeight * cameraConfigs.shadingScale), 1) : nativeHeight;

          // MsaaRadiance
          if (cameraConfigs.enableMSAA) {
            // Notice: We never store multisample results.
            // These samples are always resolved and discarded at the end of the render pass.
            // So the ResourceResidency should be MEMORYLESS.
            if (cameraConfigs.enableHDR) {
              ppl.addTexture("MsaaRadiance" + id, TextureType.TEX2D, cameraConfigs.radianceFormat, width, height, 1, 1, 1, settings.msaa.sampleCount, ResourceFlags.COLOR_ATTACHMENT, ResourceResidency.MEMORYLESS);
            } else {
              ppl.addTexture("MsaaRadiance" + id, TextureType.TEX2D, Format.RGBA8, width, height, 1, 1, 1, settings.msaa.sampleCount, ResourceFlags.COLOR_ATTACHMENT, ResourceResidency.MEMORYLESS);
            }
            ppl.addTexture("MsaaDepthStencil" + id, TextureType.TEX2D, Format.DEPTH_STENCIL, width, height, 1, 1, 1, settings.msaa.sampleCount, ResourceFlags.DEPTH_STENCIL_ATTACHMENT, ResourceResidency.MEMORYLESS);
          }

          // Mainlight ShadowMap
          ppl.addRenderTarget("ShadowMap" + id, pplConfigs.shadowMapFormat, pplConfigs.shadowMapSize.x, pplConfigs.shadowMapSize.y);
          ppl.addDepthStencil("ShadowDepth" + id, Format.DEPTH_STENCIL, pplConfigs.shadowMapSize.x, pplConfigs.shadowMapSize.y);

          // Spot-light shadow maps
          if (cameraConfigs.enableSingleForwardPass) {
            var count = pplConfigs.mobileMaxSpotLightShadowMaps;
            for (var i = 0; i !== count; ++i) {
              ppl.addRenderTarget("SpotShadowMap" + i, pplConfigs.shadowMapFormat, pplConfigs.shadowMapSize.x, pplConfigs.shadowMapSize.y);
              ppl.addDepthStencil("SpotShadowDepth" + i, Format.DEPTH_STENCIL, pplConfigs.shadowMapSize.x, pplConfigs.shadowMapSize.y);
            }
          }
        };
        _proto2.setup = function setup(ppl, pplConfigs, cameraConfigs, camera, context) {
          // Add global constants
          ppl.setVec4('g_platform', pplConfigs.platform);
          var id = camera.window.renderWindowId;
          var scene = camera.scene;
          var mainLight = scene.mainLight;
          --cameraConfigs.remainingPasses;
          assert(cameraConfigs.remainingPasses >= 0);

          // Forward Lighting (Light Culling)
          this.forwardLighting.cullLights(scene, camera.frustum);

          // Main Directional light CSM Shadow Map
          if (cameraConfigs.enableMainLightShadowMap) {
            assert(!!mainLight);
            this._addCascadedShadowMapPass(ppl, pplConfigs, id, mainLight, camera);
          }

          // Spot light shadow maps (Mobile or MSAA)
          if (cameraConfigs.enableSingleForwardPass) {
            // Currently, only support 1 spot light with shadow map on mobile platform.
            // TODO(zhouzhenglong): Relex this limitation.
            this.forwardLighting.addSpotlightShadowPasses(ppl, camera, pplConfigs.mobileMaxSpotLightShadowMaps);
          }
          this._tryAddReflectionProbePasses(ppl, cameraConfigs, id, mainLight, camera.scene);
          if (cameraConfigs.remainingPasses > 0 || cameraConfigs.enableShadingScale) {
            context.colorName = cameraConfigs.enableShadingScale ? "ScaledRadiance0_" + id : "Radiance0_" + id;
            context.depthStencilName = cameraConfigs.enableShadingScale ? "ScaledSceneDepth_" + id : "SceneDepth_" + id;
          } else {
            context.colorName = cameraConfigs.colorName;
            context.depthStencilName = cameraConfigs.depthStencilName;
          }
          var pass = this._addForwardRadiancePasses(ppl, pplConfigs, cameraConfigs, id, camera, cameraConfigs.width, cameraConfigs.height, mainLight, context.colorName, context.depthStencilName, !cameraConfigs.enableMSAA, cameraConfigs.enableStoreSceneDepth ? StoreOp.STORE : StoreOp.DISCARD);
          if (!cameraConfigs.enableStoreSceneDepth) {
            context.depthStencilName = '';
          }
          if (cameraConfigs.remainingPasses === 0 && cameraConfigs.enableShadingScale) {
            return addCopyToScreenPass(ppl, pplConfigs, cameraConfigs, context.colorName);
          } else {
            return pass;
          }
        };
        _proto2._addCascadedShadowMapPass = function _addCascadedShadowMapPass(ppl, pplConfigs, id, light, camera) {
          var QueueHint = rendering.QueueHint;
          var SceneFlags = rendering.SceneFlags;
          // ----------------------------------------------------------------
          // Dynamic states
          // ----------------------------------------------------------------
          var shadowSize = ppl.pipelineSceneData.shadows.size;
          var width = shadowSize.x;
          var height = shadowSize.y;
          var viewport = this._viewport;
          viewport.left = viewport.top = 0;
          viewport.width = width;
          viewport.height = height;

          // ----------------------------------------------------------------
          // CSM Shadow Map
          // ----------------------------------------------------------------
          var pass = ppl.addRenderPass(width, height, 'default');
          pass.name = 'CascadedShadowMap';
          pass.addRenderTarget("ShadowMap" + id, LoadOp.CLEAR, StoreOp.STORE, new Color(1, 1, 1, 1));
          pass.addDepthStencil("ShadowDepth" + id, LoadOp.CLEAR, StoreOp.DISCARD);
          var csmLevel = ppl.pipelineSceneData.csmSupported ? light.csmLevel : 1;

          // Add shadow map viewports
          for (var level = 0; level !== csmLevel; ++level) {
            getCsmMainLightViewport(light, width, height, level, this._viewport, pplConfigs.screenSpaceSignY);
            var queue = pass.addQueue(QueueHint.NONE, 'shadow-caster');
            if (!pplConfigs.isWebGPU) {
              // Temporary workaround for WebGPU
              queue.setViewport(this._viewport);
            }
            queue.addScene(camera, SceneFlags.OPAQUE | SceneFlags.MASK | SceneFlags.SHADOW_CASTER).useLightFrustum(light, level);
          }
        };
        _proto2._tryAddReflectionProbePasses = function _tryAddReflectionProbePasses(ppl, cameraConfigs, id, mainLight, scene) {
          var reflectionProbeManager = cclegacy.internal.reflectionProbeManager;
          if (!reflectionProbeManager) {
            return;
          }
          var ResourceResidency = rendering.ResourceResidency;
          var probes = reflectionProbeManager.getProbes();
          var maxProbeCount = 4;
          var probeID = 0;
          for (var _iterator9 = _createForOfIteratorHelperLoose(probes), _step9; !(_step9 = _iterator9()).done;) {
            var probe = _step9.value;
            if (!probe.needRender) {
              continue;
            }
            var area = probe.renderArea();
            var width = Math.max(Math.floor(area.x), 1);
            var height = Math.max(Math.floor(area.y), 1);
            if (probe.probeType === renderer.scene.ProbeType.PLANAR) {
              if (!cameraConfigs.enablePlanarReflectionProbe) {
                continue;
              }
              var window = probe.realtimePlanarTexture.window;
              var colorName = "PlanarProbeRT" + probeID;
              var depthStencilName = "PlanarProbeDS" + probeID;
              // ProbeResource
              ppl.addRenderWindow(colorName, cameraConfigs.radianceFormat, width, height, window);
              ppl.addDepthStencil(depthStencilName, gfx.Format.DEPTH_STENCIL, width, height, ResourceResidency.MEMORYLESS);

              // Rendering
              var probePass = ppl.addRenderPass(width, height, 'default');
              probePass.name = "PlanarReflectionProbe" + probeID;
              this._buildReflectionProbePass(probePass, cameraConfigs, id, probe.camera, colorName, depthStencilName, mainLight, scene);
            }
            ++probeID;
            if (probeID === maxProbeCount) {
              break;
            }
          }
        };
        _proto2._buildReflectionProbePass = function _buildReflectionProbePass(pass, cameraConfigs, id, camera, colorName, depthStencilName, mainLight, scene) {
          if (scene === void 0) {
            scene = null;
          }
          var QueueHint = rendering.QueueHint;
          var SceneFlags = rendering.SceneFlags;
          // set viewport
          var colorStoreOp = cameraConfigs.enableMSAA ? StoreOp.DISCARD : StoreOp.STORE;

          // bind output render target
          if (forwardNeedClearColor(camera)) {
            this._reflectionProbeClearColor.x = camera.clearColor.x;
            this._reflectionProbeClearColor.y = camera.clearColor.y;
            this._reflectionProbeClearColor.z = camera.clearColor.z;
            var clearColor = rendering.packRGBE(this._reflectionProbeClearColor);
            this._clearColor.x = clearColor.x;
            this._clearColor.y = clearColor.y;
            this._clearColor.z = clearColor.z;
            this._clearColor.w = clearColor.w;
            pass.addRenderTarget(colorName, LoadOp.CLEAR, colorStoreOp, this._clearColor);
          } else {
            pass.addRenderTarget(colorName, LoadOp.LOAD, colorStoreOp);
          }

          // bind depth stencil buffer
          if (camera.clearFlag & ClearFlagBit.DEPTH_STENCIL) {
            pass.addDepthStencil(depthStencilName, LoadOp.CLEAR, StoreOp.DISCARD, camera.clearDepth, camera.clearStencil, camera.clearFlag & ClearFlagBit.DEPTH_STENCIL);
          } else {
            pass.addDepthStencil(depthStencilName, LoadOp.LOAD, StoreOp.DISCARD);
          }

          // Set shadow map if enabled
          if (cameraConfigs.enableMainLightShadowMap) {
            pass.addTexture("ShadowMap" + id, 'cc_shadowMap');
          }

          // TODO(zhouzhenglong): Separate OPAQUE and MASK queue

          // add opaque and mask queue
          pass.addQueue(QueueHint.NONE, 'reflect-map') // Currently we put OPAQUE and MASK into one queue, so QueueHint is NONE
          .addScene(camera, SceneFlags.OPAQUE | SceneFlags.MASK | SceneFlags.REFLECTION_PROBE, mainLight || undefined, scene ? scene : undefined);
        };
        _proto2._addForwardRadiancePasses = function _addForwardRadiancePasses(ppl, pplConfigs, cameraConfigs, id, camera, width, height, mainLight, colorName, depthStencilName, disableMSAA, depthStencilStoreOp) {
          if (disableMSAA === void 0) {
            disableMSAA = false;
          }
          if (depthStencilStoreOp === void 0) {
            depthStencilStoreOp = StoreOp.DISCARD;
          }
          var QueueHint = rendering.QueueHint;
          var SceneFlags = rendering.SceneFlags;
          // ----------------------------------------------------------------
          // Dynamic states
          // ----------------------------------------------------------------
          // Prepare camera clear color
          var clearColor = camera.clearColor; // Reduce C++/TS interop
          this._clearColor.x = clearColor.x;
          this._clearColor.y = clearColor.y;
          this._clearColor.z = clearColor.z;
          this._clearColor.w = clearColor.w;

          // Prepare camera viewport
          var viewport = camera.viewport; // Reduce C++/TS interop
          this._viewport.left = Math.round(viewport.x * width);
          this._viewport.top = Math.round(viewport.y * height);
          // Here we must use camera.viewport.width instead of camera.viewport.z, which
          // is undefined on native platform. The same as camera.viewport.height.
          this._viewport.width = Math.max(Math.round(viewport.width * width), 1);
          this._viewport.height = Math.max(Math.round(viewport.height * height), 1);

          // MSAA
          var enableMSAA = !disableMSAA && cameraConfigs.enableMSAA;
          assert(!enableMSAA || cameraConfigs.enableSingleForwardPass);

          // ----------------------------------------------------------------
          // Forward Lighting (Main Directional Light)
          // ----------------------------------------------------------------
          var pass = cameraConfigs.enableSingleForwardPass ? this._addForwardSingleRadiancePass(ppl, pplConfigs, cameraConfigs, id, camera, enableMSAA, width, height, mainLight, colorName, depthStencilName, depthStencilStoreOp) : this._addForwardMultipleRadiancePasses(ppl, cameraConfigs, id, camera, width, height, mainLight, colorName, depthStencilName, depthStencilStoreOp);

          // Planar Shadow
          if (cameraConfigs.enableMainLightPlanarShadowMap) {
            this._addPlanarShadowQueue(camera, mainLight, pass);
          }

          // ----------------------------------------------------------------
          // Forward Lighting (Blend)
          // ----------------------------------------------------------------
          // Add transparent queue

          var sceneFlags = SceneFlags.BLEND | (camera.geometryRenderer ? SceneFlags.GEOMETRY : SceneFlags.NONE);
          pass.addQueue(QueueHint.BLEND).addScene(camera, sceneFlags, mainLight || undefined);
          return pass;
        };
        _proto2._addForwardSingleRadiancePass = function _addForwardSingleRadiancePass(ppl, pplConfigs, cameraConfigs, id, camera, enableMSAA, width, height, mainLight, colorName, depthStencilName, depthStencilStoreOp) {
          assert(cameraConfigs.enableSingleForwardPass);
          // ----------------------------------------------------------------
          // Forward Lighting (Main Directional Light)
          // ----------------------------------------------------------------
          var pass;
          if (enableMSAA) {
            var msaaRadianceName = "MsaaRadiance" + id;
            var msaaDepthStencilName = "MsaaDepthStencil" + id;
            var sampleCount = cameraConfigs.settings.msaa.sampleCount;
            var msPass = ppl.addMultisampleRenderPass(width, height, sampleCount, 0, 'default');
            msPass.name = 'MsaaForwardPass';

            // MSAA always discards depth stencil
            this._buildForwardMainLightPass(msPass, cameraConfigs, id, camera, msaaRadianceName, msaaDepthStencilName, StoreOp.DISCARD, mainLight);
            msPass.resolveRenderTarget(msaaRadianceName, colorName);
            pass = msPass;
          } else {
            pass = ppl.addRenderPass(width, height, 'default');
            pass.name = 'ForwardPass';
            this._buildForwardMainLightPass(pass, cameraConfigs, id, camera, colorName, depthStencilName, depthStencilStoreOp, mainLight);
          }
          assert(pass !== undefined);

          // Forward Lighting (Additive Lights)
          this.forwardLighting.addLightQueues(pass, camera, pplConfigs.mobileMaxSpotLightShadowMaps);
          return pass;
        };
        _proto2._addForwardMultipleRadiancePasses = function _addForwardMultipleRadiancePasses(ppl, cameraConfigs, id, camera, width, height, mainLight, colorName, depthStencilName, depthStencilStoreOp) {
          assert(!cameraConfigs.enableSingleForwardPass);

          // Forward Lighting (Main Directional Light)
          var pass = ppl.addRenderPass(width, height, 'default');
          pass.name = 'ForwardPass';
          var firstStoreOp = this.forwardLighting.isMultipleLightPassesNeeded() ? StoreOp.STORE : depthStencilStoreOp;
          this._buildForwardMainLightPass(pass, cameraConfigs, id, camera, colorName, depthStencilName, firstStoreOp, mainLight);

          // Forward Lighting (Additive Lights)
          pass = this.forwardLighting.addLightPasses(colorName, depthStencilName, depthStencilStoreOp, id, width, height, camera, this._viewport, ppl, pass);
          return pass;
        };
        _proto2._buildForwardMainLightPass = function _buildForwardMainLightPass(pass, cameraConfigs, id, camera, colorName, depthStencilName, depthStencilStoreOp, mainLight, scene) {
          if (scene === void 0) {
            scene = null;
          }
          var QueueHint = rendering.QueueHint;
          var SceneFlags = rendering.SceneFlags;
          // set viewport
          pass.setViewport(this._viewport);
          var colorStoreOp = cameraConfigs.enableMSAA ? StoreOp.DISCARD : StoreOp.STORE;

          // bind output render target
          if (forwardNeedClearColor(camera)) {
            pass.addRenderTarget(colorName, LoadOp.CLEAR, colorStoreOp, this._clearColor);
          } else {
            pass.addRenderTarget(colorName, LoadOp.LOAD, colorStoreOp);
          }

          // bind depth stencil buffer
          {
            if (colorName === cameraConfigs.colorName && depthStencilName !== cameraConfigs.depthStencilName) {
              warn('Default framebuffer cannot use custom depth stencil buffer');
            }
          }
          if (camera.clearFlag & ClearFlagBit.DEPTH_STENCIL) {
            pass.addDepthStencil(depthStencilName, LoadOp.CLEAR, depthStencilStoreOp, camera.clearDepth, camera.clearStencil, camera.clearFlag & ClearFlagBit.DEPTH_STENCIL);
          } else {
            pass.addDepthStencil(depthStencilName, LoadOp.LOAD, depthStencilStoreOp);
          }

          // Set shadow map if enabled
          if (cameraConfigs.enableMainLightShadowMap) {
            pass.addTexture("ShadowMap" + id, 'cc_shadowMap');
          }

          // TODO(zhouzhenglong): Separate OPAQUE and MASK queue

          // add opaque and mask queue
          pass.addQueue(QueueHint.NONE) // Currently we put OPAQUE and MASK into one queue, so QueueHint is NONE
          .addScene(camera, SceneFlags.OPAQUE | SceneFlags.MASK, mainLight || undefined, scene ? scene : undefined);
        };
        _proto2._addPlanarShadowQueue = function _addPlanarShadowQueue(camera, mainLight, pass) {
          var QueueHint = rendering.QueueHint;
          var SceneFlags = rendering.SceneFlags;
          pass.addQueue(QueueHint.BLEND, 'planar-shadow').addScene(camera, SceneFlags.SHADOW_CASTER | SceneFlags.PLANAR_SHADOW | SceneFlags.BLEND, mainLight || undefined);
        };
        return BuiltinForwardPassBuilder;
      }();
      BuiltinForwardPassBuilder.ConfigOrder = 100;
      BuiltinForwardPassBuilder.RenderOrder = 100;
      function downSize(size, scale) {
        return Math.max(Math.floor(size * scale), 1);
      }
      var BuiltinBloomPassBuilder = /*#__PURE__*/function () {
        function BuiltinBloomPassBuilder() {
          // Bloom
          this._clearColorTransparentBlack = new Color(0, 0, 0, 0);
          this._bloomParams = new Vec4(0, 0, 0, 0);
          this._bloomTexSize = new Vec4(0, 0, 0, 0);
          this._bloomWidths = [];
          this._bloomHeights = [];
          this._bloomTexNames = [];
          // Mipmap Bloom
          this._bloomUpSampleTexDescs = [];
          this._bloomDownSampleTexDescs = [];
          this._prefilterTexDesc = {
            name: '',
            width: 0,
            height: 0
          };
          this._originalColorDesc = {
            name: '',
            width: 0,
            height: 0
          };
        }
        var _proto3 = BuiltinBloomPassBuilder.prototype;
        _proto3.getConfigOrder = function getConfigOrder() {
          return 0;
        };
        _proto3.getRenderOrder = function getRenderOrder() {
          return 200;
        };
        _proto3.configCamera = function configCamera(camera, pipelineConfigs, cameraConfigs) {
          var bloom = cameraConfigs.settings.bloom;
          var hasValidMaterial = bloom.type === BloomType.KawaseDualFilter && !!bloom.kawaseFilterMaterial || bloom.type === BloomType.MipmapFilter && !!bloom.mipmapFilterMaterial;
          cameraConfigs.enableBloom = bloom.enabled && hasValidMaterial;
          if (cameraConfigs.enableBloom) {
            ++cameraConfigs.remainingPasses;
          }
        };
        _proto3.windowResize = function windowResize(ppl, pplConfigs, cameraConfigs, window) {
          if (!cameraConfigs.enableBloom) {
            return;
          }
          var width = cameraConfigs.width,
            height = cameraConfigs.height,
            bloom = cameraConfigs.settings.bloom;
          var id = window.renderWindowId;
          var format = cameraConfigs.radianceFormat;
          if (bloom.type === BloomType.KawaseDualFilter) {
            var bloomWidth = cameraConfigs.width;
            var bloomHeight = cameraConfigs.height;
            for (var i = 0; i !== bloom.iterations + 1; ++i) {
              bloomWidth = Math.max(Math.floor(bloomWidth / 2), 1);
              bloomHeight = Math.max(Math.floor(bloomHeight / 2), 1);
              ppl.addRenderTarget("BloomTex" + id + "_" + i, format, bloomWidth, bloomHeight);
            }
          } else if (bloom.type === BloomType.MipmapFilter) {
            var iterations = bloom.iterations;
            for (var _i = 0; _i !== iterations + 1; ++_i) {
              // DownSample
              if (_i < iterations) {
                var scale = Math.pow(0.5, _i + 2);
                this._bloomDownSampleTexDescs[_i] = this.createTexture(ppl, "DownSampleColor" + id + _i, downSize(width, scale), downSize(height, scale), format);
              }
              // UpSample
              if (_i < iterations - 1) {
                var _scale = Math.pow(0.5, iterations - _i - 1);
                this._bloomUpSampleTexDescs[_i] = this.createTexture(ppl, "UpSampleColor" + id + _i, downSize(width, _scale), downSize(height, _scale), format);
              }
            }
            this._originalColorDesc = this.createTexture(ppl, "OriginalColor" + id, width, height, format);
            this._prefilterTexDesc = this.createTexture(ppl, "PrefilterColor" + id, downSize(width, 0.5), downSize(height, 0.5), format);
          }
        };
        _proto3.createTexture = function createTexture(ppl, name, width, height, format) {
          var desc = {
            name: name,
            width: width,
            height: height
          };
          ppl.addRenderTarget(desc.name, format, desc.width, desc.height);
          return desc;
        };
        _proto3.setup = function setup(ppl, pplConfigs, cameraConfigs, camera, context, prevRenderPass) {
          if (!cameraConfigs.enableBloom) {
            return prevRenderPass;
          }
          --cameraConfigs.remainingPasses;
          assert(cameraConfigs.remainingPasses >= 0);
          var bloom = cameraConfigs.settings.bloom;
          var id = camera.window.renderWindowId;
          switch (bloom.type) {
            case BloomType.KawaseDualFilter:
              {
                var material = bloom.kawaseFilterMaterial;
                assert(!!material);
                return this._addKawaseDualFilterBloomPasses(ppl, pplConfigs, cameraConfigs, cameraConfigs.settings, material, id, cameraConfigs.width, cameraConfigs.height, context.colorName);
              }
            case BloomType.MipmapFilter:
              {
                var _material = bloom.mipmapFilterMaterial;
                assert(!!_material);
                return this._addMipmapFilterBloomPasses(ppl, pplConfigs, cameraConfigs, cameraConfigs.settings, _material, id, cameraConfigs.width, cameraConfigs.height, context.colorName);
              }
            default:
              return prevRenderPass;
          }
        };
        _proto3._addKawaseDualFilterBloomPasses = function _addKawaseDualFilterBloomPasses(ppl, pplConfigs, cameraConfigs, settings, bloomMaterial, id, width, height, radianceName) {
          var QueueHint = rendering.QueueHint;
          // Based on Kawase Dual Filter Blur. Saves bandwidth on mobile devices.
          // eslint-disable-next-line max-len
          // https://community.arm.com/cfs-file/__key/communityserver-blogs-components-weblogfiles/00-00-00-20-66/siggraph2015_2D00_mmg_2D00_marius_2D00_slides.pdf

          // Size: [prefilter(1/2), downsample(1/4), downsample(1/8), downsample(1/16), ...]
          var iterations = settings.bloom.iterations;
          var sizeCount = iterations + 1;
          this._bloomWidths.length = sizeCount;
          this._bloomHeights.length = sizeCount;
          this._bloomWidths[0] = Math.max(Math.floor(width / 2), 1);
          this._bloomHeights[0] = Math.max(Math.floor(height / 2), 1);
          for (var i = 1; i !== sizeCount; ++i) {
            this._bloomWidths[i] = Math.max(Math.floor(this._bloomWidths[i - 1] / 2), 1);
            this._bloomHeights[i] = Math.max(Math.floor(this._bloomHeights[i - 1] / 2), 1);
          }

          // Bloom texture names
          this._bloomTexNames.length = sizeCount;
          for (var _i2 = 0; _i2 !== sizeCount; ++_i2) {
            this._bloomTexNames[_i2] = "BloomTex" + id + "_" + _i2;
          }

          // Setup bloom parameters
          this._bloomParams.x = pplConfigs.useFloatOutput ? 1 : 0;
          this._bloomParams.y = 0; // unused
          this._bloomParams.z = settings.bloom.threshold;
          this._bloomParams.w = settings.bloom.enableAlphaMask ? 1 : 0;

          // Prefilter pass
          var prefilterPass = ppl.addRenderPass(this._bloomWidths[0], this._bloomHeights[0], 'cc-bloom-prefilter');
          prefilterPass.addRenderTarget(this._bloomTexNames[0], LoadOp.CLEAR, StoreOp.STORE, this._clearColorTransparentBlack);
          prefilterPass.addTexture(radianceName, 'inputTexture');
          prefilterPass.setVec4('bloomParams', this._bloomParams);
          prefilterPass.addQueue(QueueHint.OPAQUE).addFullscreenQuad(bloomMaterial, 0);

          // Downsample passes
          for (var _i3 = 1; _i3 !== sizeCount; ++_i3) {
            var downPass = ppl.addRenderPass(this._bloomWidths[_i3], this._bloomHeights[_i3], 'cc-bloom-downsample');
            downPass.addRenderTarget(this._bloomTexNames[_i3], LoadOp.CLEAR, StoreOp.STORE, this._clearColorTransparentBlack);
            downPass.addTexture(this._bloomTexNames[_i3 - 1], 'bloomTexture');
            this._bloomTexSize.x = this._bloomWidths[_i3 - 1];
            this._bloomTexSize.y = this._bloomHeights[_i3 - 1];
            downPass.setVec4('bloomTexSize', this._bloomTexSize);
            downPass.addQueue(QueueHint.OPAQUE).addFullscreenQuad(bloomMaterial, 1);
          }

          // Upsample passes
          for (var _i4 = iterations; _i4-- > 0;) {
            var upPass = ppl.addRenderPass(this._bloomWidths[_i4], this._bloomHeights[_i4], 'cc-bloom-upsample');
            upPass.addRenderTarget(this._bloomTexNames[_i4], LoadOp.CLEAR, StoreOp.STORE, this._clearColorTransparentBlack);
            upPass.addTexture(this._bloomTexNames[_i4 + 1], 'bloomTexture');
            this._bloomTexSize.x = this._bloomWidths[_i4 + 1];
            this._bloomTexSize.y = this._bloomHeights[_i4 + 1];
            upPass.setVec4('bloomTexSize', this._bloomTexSize);
            upPass.addQueue(QueueHint.OPAQUE).addFullscreenQuad(bloomMaterial, 2);
          }

          // Combine pass
          this._bloomParams.w = settings.bloom.intensity;
          var combinePass = ppl.addRenderPass(width, height, 'cc-bloom-combine');
          combinePass.addRenderTarget(radianceName, LoadOp.LOAD, StoreOp.STORE);
          combinePass.addTexture(this._bloomTexNames[0], 'bloomTexture');
          combinePass.setVec4('bloomParams', this._bloomParams);
          combinePass.addQueue(QueueHint.BLEND).addFullscreenQuad(bloomMaterial, 3);
          if (cameraConfigs.remainingPasses === 0) {
            return addCopyToScreenPass(ppl, pplConfigs, cameraConfigs, radianceName);
          } else {
            return combinePass;
          }
        };
        _proto3._addPass = function _addPass(ppl, width, height, layout, colorName, material, passIndex, loadOp, clearColor, queueHint) {
          if (loadOp === void 0) {
            loadOp = LoadOp.CLEAR;
          }
          if (clearColor === void 0) {
            clearColor = sClearColorTransparentBlack;
          }
          if (queueHint === void 0) {
            queueHint = rendering.QueueHint.OPAQUE;
          }
          var pass = ppl.addRenderPass(width, height, layout);
          pass.addRenderTarget(colorName, loadOp, StoreOp.STORE, clearColor);
          pass.addQueue(queueHint).addFullscreenQuad(material, passIndex);
          return pass;
        };
        _proto3._addMipmapFilterBloomPasses = function _addMipmapFilterBloomPasses(ppl, pplConfigs, cameraConfigs, settings, bloomMaterial, id, width, height, radianceName) {
          // Setup bloom parameters
          this._bloomParams.x = pplConfigs.useFloatOutput ? 1 : 0;
          this._bloomParams.x = 0; // unused
          this._bloomParams.z = settings.bloom.threshold;
          this._bloomParams.w = settings.bloom.intensity;
          var prefilterInfo = this._prefilterTexDesc;

          // Prefilter pass
          var currSamplePass = this._addPass(ppl, prefilterInfo.width, prefilterInfo.height, 'cc-bloom-mipmap-prefilter', prefilterInfo.name, bloomMaterial, 0);
          currSamplePass.addTexture(radianceName, 'mainTexture');
          currSamplePass.setVec4('bloomParams', this._bloomParams);
          var downSampleInfos = this._bloomDownSampleTexDescs;
          // Downsample passes
          for (var i = 0; i < downSampleInfos.length; ++i) {
            var currInfo = downSampleInfos[i];
            var samplerSrc = i === 0 ? prefilterInfo : downSampleInfos[i - 1];
            var samplerSrcName = samplerSrc.name;
            this._bloomTexSize.x = 1 / samplerSrc.width;
            this._bloomTexSize.y = 1 / samplerSrc.height;
            currSamplePass = this._addPass(ppl, currInfo.width, currInfo.height, 'cc-bloom-mipmap-downsample', currInfo.name, bloomMaterial, 1);
            currSamplePass.addTexture(samplerSrcName, 'mainTexture');
            currSamplePass.setVec4('bloomParams', this._bloomTexSize);
          }
          var lastIndex = downSampleInfos.length - 1;
          var upSampleInfos = this._bloomUpSampleTexDescs;
          // Upsample passes
          for (var _i5 = 0; _i5 < upSampleInfos.length; _i5++) {
            var _currInfo = upSampleInfos[_i5];
            var sampleSrc = _i5 === 0 ? downSampleInfos[lastIndex] : upSampleInfos[_i5 - 1];
            var sampleSrcName = sampleSrc.name;
            this._bloomTexSize.x = 1 / sampleSrc.width;
            this._bloomTexSize.y = 1 / sampleSrc.height;
            currSamplePass = this._addPass(ppl, _currInfo.width, _currInfo.height, 'cc-bloom-mipmap-upsample', _currInfo.name, bloomMaterial, 2);
            currSamplePass.addTexture(sampleSrcName, 'mainTexture');
            currSamplePass.addTexture(downSampleInfos[lastIndex - 1 - _i5].name, 'downsampleTexture');
            currSamplePass.setVec4('bloomParams', this._bloomTexSize);
          }

          // Combine pass
          var combinePass = this._addPass(ppl, width, height, 'cc-bloom-mipmap-combine', radianceName, bloomMaterial, 3, LoadOp.LOAD);
          combinePass.addTexture(upSampleInfos[upSampleInfos.length - 1].name, 'bloomTexture');
          combinePass.setVec4('bloomParams', this._bloomParams);
          if (cameraConfigs.remainingPasses === 0) {
            return addCopyToScreenPass(ppl, pplConfigs, cameraConfigs, radianceName);
          } else {
            return combinePass;
          }
        };
        return BuiltinBloomPassBuilder;
      }();
      var BuiltinToneMappingPassBuilder = /*#__PURE__*/function () {
        function BuiltinToneMappingPassBuilder() {
          this._colorGradingTexSize = new Vec2(0, 0);
        }
        var _proto4 = BuiltinToneMappingPassBuilder.prototype;
        _proto4.getConfigOrder = function getConfigOrder() {
          return 0;
        };
        _proto4.getRenderOrder = function getRenderOrder() {
          return 300;
        };
        _proto4.configCamera = function configCamera(camera, pplConfigs, cameraConfigs) {
          var settings = cameraConfigs.settings;
          cameraConfigs.enableColorGrading = settings.colorGrading.enabled && !!settings.colorGrading.material && !!settings.colorGrading.colorGradingMap;
          cameraConfigs.enableToneMapping = cameraConfigs.enableHDR // From Half to RGBA8
          || cameraConfigs.enableColorGrading; // Color grading

          if (cameraConfigs.enableToneMapping) {
            ++cameraConfigs.remainingPasses;
          }
        };
        _proto4.windowResize = function windowResize(ppl, pplConfigs, cameraConfigs) {
          if (cameraConfigs.enableColorGrading) {
            assert(!!cameraConfigs.settings.colorGrading.material);
            cameraConfigs.settings.colorGrading.material.setProperty('colorGradingMap', cameraConfigs.settings.colorGrading.colorGradingMap);
          }
        };
        _proto4.setup = function setup(ppl, pplConfigs, cameraConfigs, camera, context, prevRenderPass) {
          if (!cameraConfigs.enableToneMapping) {
            return prevRenderPass;
          }
          --cameraConfigs.remainingPasses;
          assert(cameraConfigs.remainingPasses >= 0);
          if (cameraConfigs.remainingPasses === 0) {
            return this._addCopyAndTonemapPass(ppl, pplConfigs, cameraConfigs, cameraConfigs.width, cameraConfigs.height, context.colorName, cameraConfigs.colorName);
          } else {
            var id = cameraConfigs.renderWindowId;
            var ldrColorPrefix = cameraConfigs.enableShadingScale ? "ScaledLdrColor" : "LdrColor";
            var ldrColorName = getPingPongRenderTarget(context.colorName, ldrColorPrefix, id);
            var radianceName = context.colorName;
            context.colorName = ldrColorName;
            return this._addCopyAndTonemapPass(ppl, pplConfigs, cameraConfigs, cameraConfigs.width, cameraConfigs.height, radianceName, ldrColorName);
          }
        };
        _proto4._addCopyAndTonemapPass = function _addCopyAndTonemapPass(ppl, pplConfigs, cameraConfigs, width, height, radianceName, colorName) {
          var pass;
          var settings = cameraConfigs.settings;
          if (cameraConfigs.enableColorGrading) {
            assert(!!settings.colorGrading.material);
            assert(!!settings.colorGrading.colorGradingMap);
            var lutTex = settings.colorGrading.colorGradingMap;
            this._colorGradingTexSize.x = lutTex.width;
            this._colorGradingTexSize.y = lutTex.height;
            var isSquareMap = lutTex.width === lutTex.height;
            if (isSquareMap) {
              pass = ppl.addRenderPass(width, height, 'cc-color-grading-8x8');
            } else {
              pass = ppl.addRenderPass(width, height, 'cc-color-grading-nx1');
            }
            pass.addRenderTarget(colorName, LoadOp.CLEAR, StoreOp.STORE, sClearColorTransparentBlack);
            pass.addTexture(radianceName, 'sceneColorMap');
            pass.setVec2('lutTextureSize', this._colorGradingTexSize);
            pass.setFloat('contribute', settings.colorGrading.contribute);
            pass.addQueue(rendering.QueueHint.OPAQUE).addFullscreenQuad(settings.colorGrading.material, isSquareMap ? 1 : 0);
          } else {
            pass = ppl.addRenderPass(width, height, 'cc-tone-mapping');
            pass.addRenderTarget(colorName, LoadOp.CLEAR, StoreOp.STORE, sClearColorTransparentBlack);
            pass.addTexture(radianceName, 'inputTexture');
            if (settings.toneMapping.material) {
              pass.addQueue(rendering.QueueHint.OPAQUE).addFullscreenQuad(settings.toneMapping.material, 0);
            } else {
              assert(!!cameraConfigs.copyAndTonemapMaterial);
              pass.addQueue(rendering.QueueHint.OPAQUE).addFullscreenQuad(cameraConfigs.copyAndTonemapMaterial, 0);
            }
          }
          return pass;
        };
        return BuiltinToneMappingPassBuilder;
      }();
      var BuiltinFXAAPassBuilder = /*#__PURE__*/function () {
        function BuiltinFXAAPassBuilder() {
          // FXAA
          this._fxaaParams = new Vec4(0, 0, 0, 0);
        }
        var _proto5 = BuiltinFXAAPassBuilder.prototype;
        _proto5.getConfigOrder = function getConfigOrder() {
          return 0;
        };
        _proto5.getRenderOrder = function getRenderOrder() {
          return 400;
        };
        _proto5.configCamera = function configCamera(camera, pplConfigs, cameraConfigs) {
          cameraConfigs.enableFXAA = cameraConfigs.settings.fxaa.enabled && !!cameraConfigs.settings.fxaa.material;
          if (cameraConfigs.enableFXAA) {
            ++cameraConfigs.remainingPasses;
          }
        };
        _proto5.setup = function setup(ppl, pplConfigs, cameraConfigs, camera, context, prevRenderPass) {
          if (!cameraConfigs.enableFXAA) {
            return prevRenderPass;
          }
          --cameraConfigs.remainingPasses;
          assert(cameraConfigs.remainingPasses >= 0);
          var id = cameraConfigs.renderWindowId;
          var ldrColorPrefix = cameraConfigs.enableShadingScale ? "ScaledLdrColor" : "LdrColor";
          var ldrColorName = getPingPongRenderTarget(context.colorName, ldrColorPrefix, id);
          assert(!!cameraConfigs.settings.fxaa.material);
          if (cameraConfigs.remainingPasses === 0) {
            if (cameraConfigs.enableShadingScale) {
              this._addFxaaPass(ppl, pplConfigs, cameraConfigs.settings.fxaa.material, cameraConfigs.width, cameraConfigs.height, context.colorName, ldrColorName);
              return addCopyToScreenPass(ppl, pplConfigs, cameraConfigs, ldrColorName);
            } else {
              assert(cameraConfigs.width === cameraConfigs.nativeWidth);
              assert(cameraConfigs.height === cameraConfigs.nativeHeight);
              return this._addFxaaPass(ppl, pplConfigs, cameraConfigs.settings.fxaa.material, cameraConfigs.width, cameraConfigs.height, context.colorName, cameraConfigs.colorName);
            }
          } else {
            var inputColorName = context.colorName;
            context.colorName = ldrColorName;
            var lastPass = this._addFxaaPass(ppl, pplConfigs, cameraConfigs.settings.fxaa.material, cameraConfigs.width, cameraConfigs.height, inputColorName, ldrColorName);
            return lastPass;
          }
        };
        _proto5._addFxaaPass = function _addFxaaPass(ppl, pplConfigs, fxaaMaterial, width, height, ldrColorName, colorName) {
          this._fxaaParams.x = width;
          this._fxaaParams.y = height;
          this._fxaaParams.z = 1 / width;
          this._fxaaParams.w = 1 / height;
          var pass = ppl.addRenderPass(width, height, 'cc-fxaa');
          pass.addRenderTarget(colorName, LoadOp.CLEAR, StoreOp.STORE, sClearColorTransparentBlack);
          pass.addTexture(ldrColorName, 'sceneColorMap');
          pass.setVec4('texSize', this._fxaaParams);
          pass.addQueue(rendering.QueueHint.OPAQUE).addFullscreenQuad(fxaaMaterial, 0);
          return pass;
        };
        return BuiltinFXAAPassBuilder;
      }();
      var BuiltinFsrPassBuilder = /*#__PURE__*/function () {
        function BuiltinFsrPassBuilder() {
          // FSR
          this._fsrParams = new Vec4(0, 0, 0, 0);
          this._fsrTexSize = new Vec4(0, 0, 0, 0);
        }
        var _proto6 = BuiltinFsrPassBuilder.prototype;
        _proto6.getConfigOrder = function getConfigOrder() {
          return 0;
        };
        _proto6.getRenderOrder = function getRenderOrder() {
          return 500;
        };
        _proto6.configCamera = function configCamera(camera, pplConfigs, cameraConfigs) {
          // FSR (Depend on Shading scale)
          cameraConfigs.enableFSR = cameraConfigs.settings.fsr.enabled && !!cameraConfigs.settings.fsr.material && cameraConfigs.enableShadingScale && cameraConfigs.shadingScale < 1.0;
          if (cameraConfigs.enableFSR) {
            ++cameraConfigs.remainingPasses;
          }
        };
        _proto6.setup = function setup(ppl, pplConfigs, cameraConfigs, camera, context, prevRenderPass) {
          if (!cameraConfigs.enableFSR) {
            return prevRenderPass;
          }
          --cameraConfigs.remainingPasses;
          var inputColorName = context.colorName;
          var outputColorName = cameraConfigs.remainingPasses === 0 ? cameraConfigs.colorName : getPingPongRenderTarget(context.colorName, 'UiColor', cameraConfigs.renderWindowId);
          context.colorName = outputColorName;
          assert(!!cameraConfigs.settings.fsr.material);
          return this._addFsrPass(ppl, pplConfigs, cameraConfigs, cameraConfigs.settings, cameraConfigs.settings.fsr.material, cameraConfigs.renderWindowId, cameraConfigs.width, cameraConfigs.height, inputColorName, cameraConfigs.nativeWidth, cameraConfigs.nativeHeight, outputColorName);
        };
        _proto6._addFsrPass = function _addFsrPass(ppl, pplConfigs, cameraConfigs, settings, fsrMaterial, id, width, height, inputColorName, nativeWidth, nativeHeight, outputColorName) {
          this._fsrTexSize.x = width;
          this._fsrTexSize.y = height;
          this._fsrTexSize.z = nativeWidth;
          this._fsrTexSize.w = nativeHeight;
          this._fsrParams.x = clamp(1.0 - settings.fsr.sharpness, 0.02, 0.98);
          var uiColorPrefix = 'UiColor';
          var fsrColorName = getPingPongRenderTarget(outputColorName, uiColorPrefix, id);
          var easuPass = ppl.addRenderPass(nativeWidth, nativeHeight, 'cc-fsr-easu');
          easuPass.addRenderTarget(fsrColorName, LoadOp.CLEAR, StoreOp.STORE, sClearColorTransparentBlack);
          easuPass.addTexture(inputColorName, 'outputResultMap');
          easuPass.setVec4('fsrTexSize', this._fsrTexSize);
          easuPass.addQueue(rendering.QueueHint.OPAQUE).addFullscreenQuad(fsrMaterial, 0);
          var rcasPass = ppl.addRenderPass(nativeWidth, nativeHeight, 'cc-fsr-rcas');
          rcasPass.addRenderTarget(outputColorName, LoadOp.CLEAR, StoreOp.STORE, sClearColorTransparentBlack);
          rcasPass.addTexture(fsrColorName, 'outputResultMap');
          rcasPass.setVec4('fsrTexSize', this._fsrTexSize);
          rcasPass.setVec4('fsrParams', this._fsrParams);
          rcasPass.addQueue(rendering.QueueHint.OPAQUE).addFullscreenQuad(fsrMaterial, 1);
          return rcasPass;
        };
        return BuiltinFsrPassBuilder;
      }();
      var BuiltinUiPassBuilder = /*#__PURE__*/function () {
        function BuiltinUiPassBuilder() {}
        var _proto7 = BuiltinUiPassBuilder.prototype;
        _proto7.getConfigOrder = function getConfigOrder() {
          return 0;
        };
        _proto7.getRenderOrder = function getRenderOrder() {
          return 1000;
        };
        _proto7.setup = function setup(ppl, pplConfigs, cameraConfigs, camera, context, prevRenderPass) {
          assert(!!prevRenderPass);
          var flags = rendering.SceneFlags.UI;
          if (cameraConfigs.enableProfiler) {
            flags |= rendering.SceneFlags.PROFILER;
            prevRenderPass.showStatistics = true;
          }
          prevRenderPass.addQueue(rendering.QueueHint.BLEND, 'default', 'default').addScene(camera, flags);
          return prevRenderPass;
        };
        return BuiltinUiPassBuilder;
      }();
      if (rendering) {
        var _QueueHint = rendering.QueueHint,
          SceneFlags = rendering.SceneFlags;
        var BuiltinPipelineBuilder = /*#__PURE__*/function () {
          function BuiltinPipelineBuilder() {
            this._pipelineEvent = cclegacy.director.root.pipelineEvent;
            this._forwardPass = new BuiltinForwardPassBuilder();
            this._bloomPass = new BuiltinBloomPassBuilder();
            this._toneMappingPass = new BuiltinToneMappingPassBuilder();
            this._fxaaPass = new BuiltinFXAAPassBuilder();
            this._fsrPass = new BuiltinFsrPassBuilder();
            this._uiPass = new BuiltinUiPassBuilder();
            // Internal cached resources
            this._clearColor = new Color(0, 0, 0, 1);
            this._viewport = new Viewport();
            this._configs = new PipelineConfigs();
            this._cameraConfigs = new CameraConfigs();
            // Materials
            this._copyAndTonemapMaterial = new Material();
            // Internal States
            this._initialized = false;
            // TODO(zhouzhenglong): Make default effect asset loading earlier and remove this flag
            this._passBuilders = [];
          }
          var _proto8 = BuiltinPipelineBuilder.prototype;
          _proto8._setupPipelinePreview = function _setupPipelinePreview(camera, cameraConfigs) {
            var isEditorView = camera.cameraUsage === CameraUsage.SCENE_VIEW || camera.cameraUsage === CameraUsage.PREVIEW;
            if (isEditorView) {
              var editorSettings = rendering.getEditorPipelineSettings();
              if (editorSettings) {
                cameraConfigs.settings = editorSettings;
              } else {
                cameraConfigs.settings = defaultSettings;
              }
            } else {
              if (camera.pipelineSettings) {
                cameraConfigs.settings = camera.pipelineSettings;
              } else {
                cameraConfigs.settings = defaultSettings;
              }
            }
          };
          _proto8._preparePipelinePasses = function _preparePipelinePasses(cameraConfigs) {
            var passBuilders = this._passBuilders;
            passBuilders.length = 0;
            var settings = cameraConfigs.settings;
            if (settings._passes) {
              for (var _iterator10 = _createForOfIteratorHelperLoose(settings._passes), _step10; !(_step10 = _iterator10()).done;) {
                var pass = _step10.value;
                passBuilders.push(pass);
              }
              assert(passBuilders.length === settings._passes.length);
            }
            passBuilders.push(this._forwardPass);
            if (settings.bloom.enabled) {
              passBuilders.push(this._bloomPass);
            }
            passBuilders.push(this._toneMappingPass);
            if (settings.fxaa.enabled) {
              passBuilders.push(this._fxaaPass);
            }
            if (settings.fsr.enabled) {
              passBuilders.push(this._fsrPass);
            }
            passBuilders.push(this._uiPass);
          };
          _proto8._setupBuiltinCameraConfigs = function _setupBuiltinCameraConfigs(ppl, camera, pipelineConfigs, cameraConfigs) {
            var window = camera.window;
            var isMainGameWindow = camera.cameraUsage === CameraUsage.GAME && !!window.swapchain;
            var isGameView = isMainGameWindow || camera.cameraUsage === CameraUsage.GAME_VIEW;

            // Window
            cameraConfigs.isMainGameWindow = isMainGameWindow;
            cameraConfigs.renderWindowId = window.renderWindowId;

            // Camera
            cameraConfigs.colorName = window.colorName;
            cameraConfigs.depthStencilName = window.depthStencilName;

            // Pipeline
            cameraConfigs.enableFullPipeline = (camera.visibility & Layers.Enum.DEFAULT) !== 0;
            cameraConfigs.enableProfiler = ppl.profiler && isGameView;
            cameraConfigs.remainingPasses = 0;

            // Shading scale
            cameraConfigs.shadingScale = cameraConfigs.settings.shadingScale;
            cameraConfigs.enableShadingScale = cameraConfigs.settings.enableShadingScale && cameraConfigs.shadingScale !== 1.0;
            cameraConfigs.nativeWidth = Math.max(Math.floor(window.width), 1);
            cameraConfigs.nativeHeight = Math.max(Math.floor(window.height), 1);
            cameraConfigs.width = cameraConfigs.enableShadingScale ? Math.max(Math.floor(cameraConfigs.nativeWidth * cameraConfigs.shadingScale), 1) : cameraConfigs.nativeWidth;
            cameraConfigs.height = cameraConfigs.enableShadingScale ? Math.max(Math.floor(cameraConfigs.nativeHeight * cameraConfigs.shadingScale), 1) : cameraConfigs.nativeHeight;

            // Radiance
            cameraConfigs.enableHDR = cameraConfigs.enableFullPipeline && pipelineConfigs.useFloatOutput;
            cameraConfigs.radianceFormat = cameraConfigs.enableHDR ? gfx.Format.RGBA16F : gfx.Format.RGBA8;

            // Tone Mapping
            cameraConfigs.copyAndTonemapMaterial = this._copyAndTonemapMaterial;

            // Depth
            cameraConfigs.enableStoreSceneDepth = false;
          };
          _proto8._setupCameraConfigs = function _setupCameraConfigs(ppl, camera, pipelineConfigs, cameraConfigs) {
            this._setupPipelinePreview(camera, cameraConfigs);
            this._preparePipelinePasses(cameraConfigs);
            sortPipelinePassBuildersByConfigOrder(this._passBuilders);
            this._setupBuiltinCameraConfigs(ppl, camera, pipelineConfigs, cameraConfigs);
            for (var _iterator11 = _createForOfIteratorHelperLoose(this._passBuilders), _step11; !(_step11 = _iterator11()).done;) {
              var builder = _step11.value;
              if (builder.configCamera) {
                builder.configCamera(camera, pipelineConfigs, cameraConfigs);
              }
            }
          }

          // ----------------------------------------------------------------
          // Interface
          // ----------------------------------------------------------------
          ;

          _proto8.windowResize = function windowResize(ppl, window, camera, nativeWidth, nativeHeight) {
            setupPipelineConfigs(ppl, this._configs);
            this._setupCameraConfigs(ppl, camera, this._configs, this._cameraConfigs);

            // Render Window (UI)
            var id = window.renderWindowId;
            ppl.addRenderWindow(this._cameraConfigs.colorName, Format.RGBA8, nativeWidth, nativeHeight, window, this._cameraConfigs.depthStencilName);
            var width = this._cameraConfigs.width;
            var height = this._cameraConfigs.height;
            if (this._cameraConfigs.enableShadingScale) {
              ppl.addDepthStencil("ScaledSceneDepth_" + id, Format.DEPTH_STENCIL, width, height);
              ppl.addRenderTarget("ScaledRadiance0_" + id, this._cameraConfigs.radianceFormat, width, height);
              ppl.addRenderTarget("ScaledRadiance1_" + id, this._cameraConfigs.radianceFormat, width, height);
              ppl.addRenderTarget("ScaledLdrColor0_" + id, Format.RGBA8, width, height);
              ppl.addRenderTarget("ScaledLdrColor1_" + id, Format.RGBA8, width, height);
            } else {
              ppl.addDepthStencil("SceneDepth_" + id, Format.DEPTH_STENCIL, width, height);
              ppl.addRenderTarget("Radiance0_" + id, this._cameraConfigs.radianceFormat, width, height);
              ppl.addRenderTarget("Radiance1_" + id, this._cameraConfigs.radianceFormat, width, height);
              ppl.addRenderTarget("LdrColor0_" + id, Format.RGBA8, width, height);
              ppl.addRenderTarget("LdrColor1_" + id, Format.RGBA8, width, height);
            }
            ppl.addRenderTarget("UiColor0_" + id, Format.RGBA8, nativeWidth, nativeHeight);
            ppl.addRenderTarget("UiColor1_" + id, Format.RGBA8, nativeWidth, nativeHeight);
            for (var _iterator12 = _createForOfIteratorHelperLoose(this._passBuilders), _step12; !(_step12 = _iterator12()).done;) {
              var builder = _step12.value;
              if (builder.windowResize) {
                builder.windowResize(ppl, this._configs, this._cameraConfigs, window, camera, nativeWidth, nativeHeight);
              }
            }
          };
          _proto8.setup = function setup(cameras, ppl) {
            // TODO(zhouzhenglong): Make default effect asset loading earlier and remove _initMaterials
            if (this._initMaterials(ppl)) {
              return;
            }

            // Render cameras
            // log(`==================== One Frame ====================`);
            for (var _iterator13 = _createForOfIteratorHelperLoose(cameras), _step13; !(_step13 = _iterator13()).done;) {
              var camera = _step13.value;
              // Skip invalid camera
              if (!camera.scene || !camera.window) {
                continue;
              }
              // Setup camera configs
              this._setupCameraConfigs(ppl, camera, this._configs, this._cameraConfigs);
              // log(`Setup camera: ${camera.node!.name}, window: ${camera.window.renderWindowId}, isFull: ${this._cameraConfigs.enableFullPipeline}, `
              //     + `size: ${camera.window.width}x${camera.window.height}`);

              this._pipelineEvent.emit(PipelineEventType.RENDER_CAMERA_BEGIN, camera);

              // Build pipeline
              if (this._cameraConfigs.enableFullPipeline) {
                this._buildForwardPipeline(ppl, camera, camera.scene, this._passBuilders);
              } else {
                this._buildSimplePipeline(ppl, camera);
              }
              this._pipelineEvent.emit(PipelineEventType.RENDER_CAMERA_END, camera);
            }
          }
          // ----------------------------------------------------------------
          // Pipelines
          // ----------------------------------------------------------------
          ;

          _proto8._buildSimplePipeline = function _buildSimplePipeline(ppl, camera) {
            var width = Math.max(Math.floor(camera.window.width), 1);
            var height = Math.max(Math.floor(camera.window.height), 1);
            var colorName = this._cameraConfigs.colorName;
            var depthStencilName = this._cameraConfigs.depthStencilName;
            var viewport = camera.viewport; // Reduce C++/TS interop
            this._viewport.left = Math.round(viewport.x * width);
            this._viewport.top = Math.round(viewport.y * height);
            // Here we must use camera.viewport.width instead of camera.viewport.z, which
            // is undefined on native platform. The same as camera.viewport.height.
            this._viewport.width = Math.max(Math.round(viewport.width * width), 1);
            this._viewport.height = Math.max(Math.round(viewport.height * height), 1);
            var clearColor = camera.clearColor; // Reduce C++/TS interop
            this._clearColor.x = clearColor.x;
            this._clearColor.y = clearColor.y;
            this._clearColor.z = clearColor.z;
            this._clearColor.w = clearColor.w;
            var pass = ppl.addRenderPass(width, height, 'default');

            // bind output render target
            if (forwardNeedClearColor(camera)) {
              pass.addRenderTarget(colorName, LoadOp.CLEAR, StoreOp.STORE, this._clearColor);
            } else {
              pass.addRenderTarget(colorName, LoadOp.LOAD, StoreOp.STORE);
            }

            // bind depth stencil buffer
            if (camera.clearFlag & ClearFlagBit.DEPTH_STENCIL) {
              pass.addDepthStencil(depthStencilName, LoadOp.CLEAR, StoreOp.DISCARD, camera.clearDepth, camera.clearStencil, camera.clearFlag & ClearFlagBit.DEPTH_STENCIL);
            } else {
              pass.addDepthStencil(depthStencilName, LoadOp.LOAD, StoreOp.DISCARD);
            }
            pass.setViewport(this._viewport);

            // The opaque queue is used for Reflection probe preview
            pass.addQueue(_QueueHint.OPAQUE).addScene(camera, SceneFlags.OPAQUE);

            // The blend queue is used for UI and Gizmos
            var flags = SceneFlags.BLEND | SceneFlags.UI;
            if (this._cameraConfigs.enableProfiler) {
              flags |= SceneFlags.PROFILER;
              pass.showStatistics = true;
            }
            pass.addQueue(_QueueHint.BLEND).addScene(camera, flags);
          };
          _proto8._buildForwardPipeline = function _buildForwardPipeline(ppl, camera, scene, passBuilders) {
            sortPipelinePassBuildersByRenderOrder(passBuilders);
            var context = {
              colorName: '',
              depthStencilName: ''
            };
            var lastPass = undefined;
            for (var _iterator14 = _createForOfIteratorHelperLoose(passBuilders), _step14; !(_step14 = _iterator14()).done;) {
              var builder = _step14.value;
              if (builder.setup) {
                lastPass = builder.setup(ppl, this._configs, this._cameraConfigs, camera, context, lastPass);
              }
            }
            assert(this._cameraConfigs.remainingPasses === 0);
          };
          _proto8._initMaterials = function _initMaterials(ppl) {
            if (this._initialized) {
              return 0;
            }
            setupPipelineConfigs(ppl, this._configs);

            // When add new effect asset, please add its uuid to the dependentAssets in cc.config.json.
            this._copyAndTonemapMaterial._uuid = "builtin-pipeline-tone-mapping-material";
            this._copyAndTonemapMaterial.initialize({
              effectName: 'pipeline/post-process/tone-mapping'
            });
            if (this._copyAndTonemapMaterial.effectAsset) {
              this._initialized = true;
            }
            return this._initialized ? 0 : 1;
          };
          return BuiltinPipelineBuilder;
        }();
        rendering.setCustomPipeline('Builtin', new BuiltinPipelineBuilder());
      } // if (rendering)
      cclegacy._RF.pop();
    }
  };
});

(function(r) {
  r('virtual:///prerequisite-imports/internal', 'chunks:///internal.js'); 
})(function(mid, cid) {
    System.register(mid, [cid], function (_export, _context) {
    return {
        setters: [function(_m) {
            var _exportObj = {};

            for (var _key in _m) {
              if (_key !== "default" && _key !== "__esModule") _exportObj[_key] = _m[_key];
            }
      
            _export(_exportObj);
        }],
        execute: function () { }
    };
    });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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